<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment\Like;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\Post\PostCommentLikeTable;

final class PostCommentLikeBuilder implements InterfacePostCommentLikeSetter
{
    /**
     * setter interface
     */
    use TraitPostCommentLikeSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            PostCommentLikeTable::LIKED_BY_USER_ID       => '',
            PostCommentLikeTable::LIKED_POST_COMMENT_ID  => '',

            PostCommentLikeTable::PARENT_POST_ID         => '',

            PostCommentLikeTable::STAMP_REGISTRATION     => System::isoDateTime(),
            PostCommentLikeTable::STAMP_LAST_UPDATE      => System::isoDateTime(),
        );
    }

    public function dispense(): PostCommentLikeModel
    {
        return PostCommentLikeModel::createFromData(
            array(
                // liked by user id

                PostCommentLikeTable::LIKED_BY_USER_ID => $this -> likedByUserId

                ?? $this -> defaultValues[PostCommentLikeTable::LIKED_BY_USER_ID],

                // liked post comment id

                PostCommentLikeTable::LIKED_POST_COMMENT_ID  => $this -> likedPostCommentId

                ?? $this -> defaultValues[PostCommentLikeTable::LIKED_POST_COMMENT_ID],

                // parent post id

                PostCommentLikeTable::PARENT_POST_ID => $this -> parentPostId

                ?? $this -> defaultValues[PostCommentLikeTable::PARENT_POST_ID],

                // stamp registration

                PostCommentLikeTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[PostCommentLikeTable::STAMP_REGISTRATION],

                // stamp last update

                PostCommentLikeTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[PostCommentLikeTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
